#require 'gtk2'
require 'gtk3'

tv = [
	["item01","item02"],
	["item11","item12"],
	["item21","item22"],
	["item31","item32"],
	["item41","item42"],
	["item51","item52"],
	["item61","item62"],
	["item71","item72"],
	["item81","item82"],
	["item91","item92"],
	]

ls = Gtk::ListStore.new(*([String] * 5))

treeview = Gtk::TreeView.new
treeview.set_model(ls)

treeview.append_column ::Gtk::TreeViewColumn.new("label1", ::Gtk::CellRendererText.new, text: 0)
treeview.append_column ::Gtk::TreeViewColumn.new("label2", ::Gtk::CellRendererText.new, text: 1)

tv.each do |val|
  iter = ls.append
  iter.set_value(0, val[0])
  iter.set_value(1, val[1])
end

win = Gtk::Window.new
win.title = 'TreeView visible_range test'
win.set_size_request 100, 200

sw = Gtk::ScrolledWindow.new
if sw.respond_to? :set_propagate_natural_width
  sw.propagate_natural_width = true
  sw.propagate_natural_height = true
  gtkversion = 3
end
sw.add_with_viewport(treeview)

#box = Gtk::Box.new(:vertical)
box = Gtk::VBox.new
box.pack_start(sw, expand: true)

win.add box
win.signal_connect('destroy') { Gtk.main_quit }
win.show_all

if gtkversion == 3
  dummy, start_path, end_path = treeview.visible_range
else
  start_path, end_path = treeview.visible_range
end
label = Gtk::Label.new("start_path: " + start_path.to_s)
label.set_alignment(0, 0.5)
box.pack_start(label, expand: true)
label = Gtk::Label.new("end_path:   " + end_path.to_s)
label.set_alignment(0, 0.5)
box.pack_start(label, expand: true)
win.show_all

Gtk.main